<?php
namespace VM\AdminBundle\Command;

use Doctrine\Bundle\DoctrineBundle\Registry;
use Doctrine\ORM\EntityManager;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use VM\ApiBundle\Entity\Round;

class EndRoundCommand extends ContainerAwareCommand
{
    private $Container;

    protected function configure()
    {
        $this
            ->setName('game:end:round')
            ->setDescription('End rounds which should end in last minute')
            ->addOption('account-changes', null, InputOption::VALUE_REQUIRED, 'Do not create account changes', 0)

        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $EndRound = $this->getContainer()->get('vm_admin.end_round');
        $rounds = $EndRound->getRoundsToEnd();

        $createAccountChanges = ($input->getOption('account-changes', 0) == 1) ? true : false;

        $roundsNotCount = array();

        foreach($rounds as $Round)
        {
            $Round->setIsCounting(true);
        }
        $this->getDoctrine()->getManager()->flush();
        /** @var Round $Round */
        foreach($rounds as $Round)
        {
            $this->getDoctrine()->getConnection()->beginTransaction();
            $output->writeln('Runda ID:<info>' . $Round->getId() . '</info>, grupa: <info>' . $Round->getGroup()->getName() . '</info>');

            try
            {
                $PrevRound = $EndRound->getPreviousRound($Round);
                if($PrevRound !== false && !$PrevRound->getIsDone())
                {
                    throw new \Exception('Poprzednia runda nie została zakończona');
                }

                $EndRound->endRound($Round, $createAccountChanges);
                $Round->setIsCounting(false);
                $Round->setIsDone(true);

                $this->getDoctrine()->getManager()->flush();
                $this->getDoctrine()->getConnection()->commit();
            }
            catch(\Exception $Exception)
            {
                $this->getDoctrine()->getConnection()->rollback();
                $Round->setIsCounting(false);
                $this->getDoctrine()->getManager()->flush();
                $roundsNotCount[] = $Round;
                $output->writeln('<error>Runda (' . $Round->getId() . ') nie została przeliczona!</error> ' . $Exception->getMessage() . '');
            }
        }
    }


    /**
     * @return Registry
     */
    protected function getDoctrine()
    {
        return $this->getContainer()->get('doctrine');
    }
}